DECLARE SUB BoxMake (Left%, Top%, Wide%, High%, Depth%, InOut%)
DEFINT A-Z

'SUB BoxFill (Top, Left, High, Wide, FillColor)
SUB BoxFill (D())

          LINE (D(1), D(2))-STEP(D(3), D(4)), D(5), BF

END SUB

'SUB BoxIn (Top, Left, High, Wide, Depth)
SUB BoxIn (D())

          CALL BoxMake(D(1), D(2), D(3), D(4), D(5), 0)

END SUB

SUB BoxMake (Left, Top, Wide, High, BoxDepth, InOut)

' -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

          SELECT CASE InOut
                  CASE 0: Color1 = 8: Color2 = 5
                  CASE 1: Color1 = 5: Color2 = 8
          END SELECT
' -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

          Depth = BoxDepth

          IF Depth < 1 OR Depth > 9 THEN Depth = 1

          Depth = Depth - 1
          FOR D = 0 TO Depth

               GOSUB MakeBox

          NEXT D

EXIT SUB

' -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
MakeBox:

          LINE (Left + D, Top + D)-STEP(0, High - 2 * D), Color1
          LINE (Left + D, Top + D)-STEP(Wide - 2 * D, 0), Color1
          LINE -STEP(0, High - 2 * D), Color2
          LINE -STEP(-Wide + 2 * D, 0), Color2

RETURN

' -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

END SUB

SUB BoxOut (D())

          CALL BoxMake(D(1), D(2), D(3), D(4), D(5), 1)
          
END SUB

SUB BoxRound (Left, Top, Wide, High, Radius, FillColor)

     pi! = 3.141593
     Diameter = Radius * 2

     '--- top
     LINE (Left + Radius, Top)-STEP(Wide - Diameter, 0), FillColor

     '--- bottom
     LINE (Left + Radius, Top + High)-STEP(Wide - Diameter, 0), FillColor

     '--- left side
     LINE (Left, Top + Radius)-STEP(0, High - Diameter), FillColor

     '--- right side
     LINE (Left + Wide, Top + Radius)-STEP(0, High - Diameter), FillColor

     '--- upper left arc
     CIRCLE (Left + Radius, Top + Radius), Radius, FillColor, pi! / 2, pi!

     '--- lower left arc
     CIRCLE (Left + Radius, Top + High - Radius), Radius, FillColor, pi!, pi! * 1.5

     '--- upper right arc
     CIRCLE (Left + Wide - Radius, Top + Radius), Radius, FillColor, 0, pi! / 2

     '--- lower right arc
     CIRCLE (Left + Wide - Radius, Top + High - Radius), Radius, FillColor, pi! * 1.5, 0

     PAINT STEP(0, 0), FillColor

END SUB

SUB ClearBox (D())

          O1 = D(5) + 1
          O2 = 2 * O1
          VIEW (D(1) + O1, D(2) + O1)-(D(1) + D(3) - O2, D(2) + D(4) - O2), 0
          CALL MouseHide
          CLS
          VIEW
          CALL MouseShow

END SUB

SUB EraseBox (D())

          VIEW (D(1), D(2))-(D(1) + D(3), D(2) + D(4)), 0
          CALL MouseHide
          CLS
          VIEW
          CALL MouseShow

END SUB

